﻿using Spectral1_VBClassLibrary;
using System;
using Spectral1.DATA_ACCESS;
using System.Windows.Forms;
using static Spectral1.DATA_ACCESS.DA_Spectral;

namespace Spectral1.BUSINESS_LOGIC
{
    public class BL_WaveSet
    {


        #region "================ DECLARATIONS ========================"
        private PL_Main _plm;
        static CodeGen_DS_Spectral _CGS;
        static DA_Spectral _DASP;
        private c_waveform_set _current_waveform_set;

        #endregion

        #region "================ PROPERTIES ========================"
        public c_waveform_set current_waveform_set
        {
            get
            {
                if (_current_waveform_set != null)
                {
                    return _current_waveform_set;
                }
                else
                {
                    set_current_waveform_set(1, 0, 0);//1 because 0 is reserver for a default name.
                    return _current_waveform_set;
                }
            }
        }
        #endregion

        #region "================ METHODS ========================"
        public BL_WaveSet(CodeGen_DS_Spectral CGS, DA_Spectral DASP,PL_Main plm)
        {
            _CGS = CGS;
            _DASP = DASP;
            _plm = plm;
        }

        public int add_new_waveset(string new_waveset_name)
        {
            _plm.BL.DA.DASystem.flag_initialising_waveset = true; _plm.BL.DA.DASystem.flag_disable_waveform_update = true;
            int new_waveset_id = _CGS.Table_waveform_set.AddRow();
            set_current_waveform_set(new_waveset_id, 0, 0);
            if (new_waveset_name != "") { current_waveform_set.name = new_waveset_name; }
            current_waveform_set.intensitycc = used_midi_cc.ucc_velocity;
            _plm.BL.BLWaveSet.current_waveform_set.create_associated_data_rows();
            _plm.BL.DA.DASystem.flag_initialising_waveset = false; _plm.BL.DA.DASystem.flag_disable_waveform_update = false;

            return new_waveset_id;
        }

        public void set_current_waveform_set(Int32 ws, Int32 initial_note_sector_id, Int32 initial_intensity_layer_id)
        {
            _current_waveform_set = new c_waveform_set(_CGS, _DASP, ws, initial_note_sector_id, initial_intensity_layer_id);
            _CGS.Table_waveform.SetDefaultViewFilter("waveform_set_id = " + ws.ToString() + " AND note_sector_id = " + initial_note_sector_id.ToString() + " AND intensity_layer_id = " + initial_intensity_layer_id.ToString());
        }

        public void set_current_waveform_set_from_table_waveform_set_current_row(Int32 initial_note_sector_id, Int32 initial_intensity_layer_id)
        {
            set_current_waveform_set(_CGS.Table_waveform_set.CurrentRow.waveform_set_id, initial_note_sector_id, initial_intensity_layer_id);
        }

        public void refresh_current_waveform_set_from_DGV(ref DataGridView DGV)
        {
            _CGS.Table_waveform_set.RefreshCurrentRowValuesFromDGV(ref DGV);
        }

        #endregion

    }
}
